%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


clf
clear all;close all;
load 'V.mat';

%%%%% to store 2D MRIs. After saving all images, make the lines 6~25
%%%%% comments.
for k=10:1:161
R = V(:,:,k);
figure;
imshow(R, []);
[row,col] = size(R);
for i=1:row
    for j=1:col
        if R(i,j) > 254
            test(i,j) = 0;
        else
            test(i,j) = 255;
        end
    end
end
figure;
imshow(test,[]);
filename = ['slice_', num2str(k), '.jpg'];
imwrite(test, filename, 'jpg');
close all;
end


%% open each of the saved images and make them as clear as possible. 
%% and Then, run the below line.

ori = imread('slice_10.jpg'); %file name should be written by user 
 M = rgb2gray(ori);
%  M = ori;
figure;
imshow(M);

%%% for filtering the image
% H = fspecial('gaussian', 3, 0.5);
% M_filter = imfilter(M,H,'replicate');
% figure;
% imshow(M_filter);

X = zeros(size(M));
for i=1:size(M,1)
    for j=1:size(M,2)
        if(M(i,j) >= 200)
            X(i,j) = 255;
            X(i,j) = 255;
        end
    end
end

figure;
imshow(X);
imwrite(X, 'slice_10_seg.png', 'png');

% % 
